<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;

class StoreDestinationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $slug = Str::slug($this->name);

        return [
            'name' => ['required', 'string', 'max:255', Rule::unique('destinations', 'slug')->where('country_id', $this->country_id)->where('state_id', $this->state_id)->where('slug', $slug)],
            'country_id' => 'required|exists:countries,id',
            'state_id' => 'required|exists:states,id',
            'city_id' => 'required|exists:cities,id',
            'places' => 'nullable|array',
            'places.*' => 'required|string|max:255',
            'description' => 'nullable|string',
            'status' => 'nullable|boolean',
            'thumbnail' => 'nullable|image|mimes:png,jpg,jpeg|max:2048',
        ];
    }
}
